#version 330
#extension GL_EXT_gpu_shader4 : enable
//The Universe 1Mod01.fsh  by   altera0 

//https://www.shadertoy.com/view/wtSBRD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define S(a, b, t) smoothstep( a, b, t )  

float DistLine( vec2 p , vec2 a , vec2 b ) {

    // Line ba에 Pa를 직교 투영한다.
    
    vec2 pa = p - a;
    vec2 ba = b - a;
    
    float t = clamp( dot( pa , ba ) / dot ( ba , ba ) , 0.0 , 1.0 );
    
    return length( pa - ba * t );
        
}

float N21( vec2 p ) {

    p = fract( p * vec2( 233.34 , 851.73));
    p += dot( p, p+23.45);
    return fract(p.x * p.y );
}

vec2 N22( vec2 p ) {
	float n = N21( p );
    return vec2( n , N21( p + n ) );
}



vec2 GetPos( vec2 id , vec2 offset ) {	// from id
    
    //vec2 n = N22( id + offset ) * iTime ;
    vec2 n = N22( id + offset ) * iTime ;
    
    //float x = sin ( iTime * n.x );
    //float y = cos ( iTime * n.y );
    
    return offset + sin( vec2(n) ) * 0.4;		// 0.4, it is Important that balls is in grid cell.
    
}

float Line( vec2 p , vec2 a , vec2 b ) {
	float d = DistLine( p , a, b );
   	float m = S( 0.03, 0.01 , d );
    
    m *= S( 1.2, 0.8 , length( a - b ) );
    
    return m;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - 0.5 * iResolution.xy) /iResolution.y;
    
    //float d = DistLine( uv , vec2(0) , vec2(1) );
    //float m = S( 0.1, 0.05 , d );
    float m;
    
    
    //m = N22( uv ).x;
    
    uv *= 5.0;
    vec2 gv = fract(uv) - 0.5f;	// center point to ( 0 , 0 ) local uv
    vec2 id = floor(uv);
    
    
    //vec2 p = N22( id ) - 0.5;	// Random point based on each grid center.
    
    //vec2 p = GetPos( id );
    //float d = length( p - gv );
    
	
    int i = 0;		// index
    vec2 p[9];		// 9 cell
    
    for (float y = -1.0 ; y <= 1.0 ; y++ ) {
        for ( float x = -1.0 ; x <= 1.0 ; x++ ) {
        	p[i++] = GetPos( id , vec2( x , y ));
        }
    }
    
    
    float t = iTime * 10.0;
    for ( int i = 0 ; i < 9 ; i++ ) {
    	m += Line( gv, p[4] , p[i] );	// p[4] is mine
        
        vec2 j = ( p[i] - gv ) * 10.0;
        float sparkle = 1.0 / dot(j,j);
        
        
        
        m += sparkle * ( sin(t + p[i].x * 10.0 ) * 0.5 + 0.5 ) ;
    }
    
    m += Line( gv, p[1] , p[3] );	// p[4] is mine
    m += Line( gv, p[1] , p[5] );	// p[4] is mine
    m += Line( gv, p[7] , p[3] );	// p[4] is mine
    m += Line( gv, p[7] , p[5] );	// p[4] is mine
    
    
   

    vec3 col = vec3(m);
    
    //col.rg = gv;
    if ( gv.x > 0.49 || gv.y > 0.49) col = vec3(1.0 , 0.0 , 0.0 );
    gl_FragColor = vec4(col,1.0);
}